

var ctx, canvas, canvasEvent, stage, exportRoot, anim_container, dom_overlay_container, fnStartAnimation, mousePos;
var EVENT = {};
var supportTouch;
var scale = 1;

function eventRegistration()
{
	// ^b`Cxgp\̔
	supportTouch = 'ontouchend' in document;
		
	// Cxg
	EVENT.touchstart = supportTouch ? 'touchstart' : 'mousedown';
	EVENT.touchmove = supportTouch ? 'touchmove' : 'mousemove';
	EVENT.touchend = supportTouch ? 'touchend' : 'mouseup';
	EVENT.tap = supportTouch ? 'touchend' : 'click';
	//EVENT.scroll = 'onwheel' in document ? 'onwheel' : 'onmousewheel' in document ? 'onmousewheel' : 'DOMMouseScroll';
	EVENT.scroll = 'onwheel' in document ? 'wheel' : 'onmousewheel' in document ? 'mousewheel' : 'DOMMouseScroll';
}

/*
function init() 
{
	canvas = document.getElementById("canvas");
	ctx = canvas.getContext('2d');

	anim_container = document.getElementById("animation_container");
	dom_overlay_container = document.getElementById("dom_overlay_container");
	var comp=AdobeAn.getComposition("4CE39E7FD033DC4C8A8D2BAD5A5570EE");
	var lib=comp.getLibrary();
	handleComplete({},comp);

	//Cxgo^
	eventRegistration();

	//g
	//zoom();

	//ړ
	pan();
}
*/



/* }EXzC[ŊgEk */
function zoom()
{
	var context = canvas.getContext('2d');

	$('#canvas').off(EVENT.scroll);
	$('#canvas').on(EVENT.scroll, function(e) 
	{
        e.preventDefault();

		var scale = stage.scaleX;

        var delta = e.originalEvent.deltaY ? -(e.originalEvent.deltaY) : e.originalEvent.wheelDelta ? e.originalEvent.wheelDelta : -(e.originalEvent.detail);
        if (delta < 0){
            // }EXzC[ɃXN[
				scale /= 1.2;
        } else {
            // }EXzC[ɃXN[
			scale *= 1.2;
        }

		//alert(mousePos.x);
		//alert(mousePos.y);

		// UNA 
		context.clearRect(0, 0, canvas.width, canvas.height);

		context.translate(mousePos.x, mousePos.y);

	  	// {ύX
		stage.scaleX = scale;
		stage.scaleY = scale;

		stage.tickOnUpdate = false;
		stage.update();
		stage.tickOnUpdate = true;

		// ϊ}gNXɖ߂
		context.scale(1 / scale, 1 / scale);

	});
}


/* hbOňړ */
function pan()
{
	var context = canvas.getContext('2d');

	// hbOԂǂ
	let isDragging = false;

	// hbOJnʒu
	let start = 
	{
		x: 0,
		y: 0
	};

	// hbÖʒu
	let diff = 
	{
		x: 0,
		y: 0
	};

	// hbOÏʒu
	let end = 
	{
		x: 0,
		y: 0
	}

	const redraw = function() 
	{
		context.clearRect(0, 0, canvas.width, canvas.height);
		//context.drawImage(img, diff.x, diff.y)

		stage.x = diff.x;
		stage.y = diff.y;

		stage.tickOnUpdate = false;
		stage.update();
		stage.tickOnUpdate = true;
	};

	$('#canvas').off(EVENT.touchstart);
	$('#canvas').on(EVENT.touchstart, function(evt) 
	{
		isDragging = true;
		start.x = evt.clientX;
		start.y = evt.clientY;

	});

	$('#canvas').off(EVENT.touchmove); 
	$('#canvas').on(EVENT.touchmove, function(evt) 
	{
		if (isDragging) 
		{
			diff.x = (evt.clientX - start.x) + end.x;
			diff.y = (evt.clientY - start.y) + end.y;
			redraw();
		}
		else
		{
          mousePos = getMousePosition(canvas, evt);
          var message = 'Mouse position X:' + mousePos.x + ', Y:' + mousePos.y;
          //PrintPosition(canvas, message);			
		}

	});

	$('#canvas').off(EVENT.touchend);
	$('#canvas').on(EVENT.touchend, function(evt) 
	{
		isDragging = false;
		end.x = diff.x;
		end.y = diff.y;

	});
}